### 实验名称

NLP词法分析

### 实验目的

1、掌握NLP中文本处理一般流程

2、掌握中文文本处理中的分词方法

3、掌握几种文本内容向量化的方法以及对应的实现

### 实验背景

自然语言处理（Natural Language Processing，简称NLP）就是用计算机来处理、理解以及运用人类语言(如中文、英文等)，它属于人工智能的一个分支。

自然语言处理具有广泛的应用前景。特别是在信息时代，自然语言处理的应用包罗万象，例如：机器翻译、手写体和印刷体字符识别、语音识别及文语转换、信息检索、信息抽取与过滤、文本分类与聚类、舆情分析和观点挖掘等。

由于自然语言的复杂性，因此把自然语言处理成机器能“理解“的形式是最基础的一步任务。本实验讲描述自然语言处理中文本处理的流程和各个环节内容。

### 实验原理

将自然语言处理成机器能“理解“的形式是基础任务，机器能理解的东西是什么呢？就是向量了。计算机就是对向量进行计算才进一步实现了对语言理解的任务。将文本数据转换成向量这种数学形式就是文本预处理。

文本预处理的流程通常包含以下步骤：获取原始文本、文本清洗、分词、词性标注、去除停用词、向量化。其中文本清洗指的是去除文本中无用的符号；分词指的是把文本内容分割成以词为基本单元的集合，去除停用词是指去除文本中的语义含量低的词单元；向量化意思是把词集合表示成向量的数学形式。

在本实验中，我们跳过获取原始文本、文本清洗两个基础 的环节，直接使用jieba库进行中文文本分词、词性标注，最后我们会介绍去除停用词的方法以及词袋表示法。

jieba分词算法：

*   基于前缀词典实现高效的词图扫描，生成句子中汉字所有可能成词情况所构成的有向无环图 (DAG)
*   采用了动态规划查找最大概率路径, 找出基于词频的最大切分组合
*   对于未登录词，采用了基于汉字成词能力的 HMM 模型，使用了 Viterbi 算法

### 实验环境

Ubuntu 18.04 

Python 3.9 

jupyter notebook 6.1.0 

pandas 2.0.3 

scikit-learn 1.4.1 

scipy 1.12.0 

jieba 0.42.1

### 建议课时

3课时

### 实验步骤

#### 环境准备

双击打开桌面的“terminal”后，在命令行中输入如下命令，开启jupyter notebook：

```python
jupyter notebook
```

打开Jupter，点击右上角上的“New”按钮，选择“python3”创建文件。

![1721522453348.png](./pic/1721522453348.png)

#### 英文分词

在打开的notebook中输入如下代码，点击运行。即可看到分词结果。

```python
def tokenize_english_text(text):
    tokenized_text = []
    for data in text:
        tokenized_data = []
        for s in data.split('.'):
            for s1 in s.split('?'):
                for s2 in s1.split('!'):
                    for s3 in s2.split(','):
                        tokenized_data.extend(
                            s4 for s4 in s3.split(' ') if s4 != '')
        tokenized_text.append(tokenized_data)
    return tokenized_text

a = ['i am a boy?i am a boy ! i am a boy,i', 'god is a girl', 'i love you!']
result = tokenize_english_text(a)
print(result)
```

结果如下：

\[\['i', 'am', 'a', 'boy', 'i', 'am', 'a', 'boy', 'i', 'am', 'a', 'boy', 'i'\], \['god', 'is', 'a', 'girl'\], \['i', 'love', 'you'\]\]

#### 用 Python的jieba库实现分词

1、安装jieba库

jupyter中pip安装库前面需要加！

```python
!pip install jieba==0.42.1
```

2、打开Jupter，编写代码，首先导入jieba库

```python
import jieba
```

jieba分词支持四种分词模式：

*   精确模式，试图将句子最精确地切开，适合文本分析；
*   全模式，把句子中所有的可以成词的词语都扫描出来, 速度非常快，但是不能解决歧义；
*   搜索引擎模式，在精确模式的基础上，对长词再次切分，提高召回率，适合用于搜索引擎分词。
*   paddle模式，利用PaddlePaddle深度学习框架，训练序列标注（双向GRU）网络模型实现分词。同时支持词性标注。paddle模式使用需安装paddlepaddle。目前paddle模式支持jieba v0.40及以上版本。

查看cut方法的说明：

```python
import jieba
help(jieba.cut)
 
```

![x-cut.png](./pic/x-cut.png)

所有分词方法的说明：

*   jieba.cut 方法接受四个输入参数: 需要分词的字符串；cut\_all 参数用来控制是否采用全模式；HMM 参数用来控制是否使用 HMM 模型；use\_paddle 参数用来控制是否使用paddle模式下的分词模式
*   jieba.cut\_for\_search 方法接受两个参数：需要分词的字符串；是否使用 HMM 模型。该方法适合用于搜索引擎构建倒排索引的分词，粒度比较细
*   jieba.cut 以及 jieba.cut\_for\_search 返回的结构都是一个可迭代的 generator，可以使用 for 循环来获得分词后得到的每一个词语(unicode)，或者用
*   jieba.lcut 以及 jieba.lcut\_for\_search 直接返回 list
*   jieba.Tokenizer(dictionary=DEFAULT\_DICT) 新建自定义分词器，可用于同时使用不同词典。jieba.dt 为默认分词器，所有全局分词相关函数都是该分词器的映射。

分词方法的应用：

代码示例

```python
# encoding=utf-8
import jieba
# 若paddle版本为最新的2.5.0，可根据报错提示加入以下两行初始化配置
# import paddle
# paddle.enable_static()
#jieba.enable_paddle()# 启动paddle模式。 0.40版之后开始支持，早期版本不支持
strs=["我来到北京清华大学","乒乓球拍卖完了","中国科学技术大学"]
for str in strs:
    seg_list = jieba.cut(str,use_paddle=True) # 使用paddle模式
    print("Paddle Mode: " + '/'.join(list(seg_list)))

seg_list = jieba.cut("我来到北京清华大学", cut_all=True)
print("【全模式】: " + "/ ".join(seg_list))  # 全模式

seg_list = jieba.cut("我来到北京清华大学", cut_all=False)
print("【精确模式/默认】: " + "/ ".join(seg_list))  # 精确模式

seg_list = jieba.cut("他来到了网易杭研大厦")  # (此处，“杭研”并没有在词典中，但是也被Viterbi算法识别出来了)
print("【新词识别】: " + ", ".join(seg_list))

seg_list = jieba.cut_for_search("小明硕士毕业于中国科学院计算所，后在日本京都大学深造")  # 搜索引擎模式
print("【搜索引擎模式】: " + ", ".join(seg_list))
 
```

输出:

![x-cut-r.png](./pic/x-cut-r.png)

3、全模式代码：

```python
string = '我来到北京清华大学'

seg_list = jieba.cut(string, cut_all=True)

result='| '.join(seg_list)

print(result)
```

运行后结果为：

'我| 来到| 北京| 清华| 清华大学| 华大| 大学'

4、精确模式：

```python
seg_list = jieba.cut(string, cut_all=False)

result2='|'.join(seg_list)

print(result2)
```

运行后结果为：

'我|来到|北京|清华大学'

5、搜索引擎模式：

```python
seg_list = jieba.cut_for_search(string)

result3='|'.join(seg_list)

print(result3)
```

运行后结果为：

'我|来到|北京|清华|华大|大学|清华大学'

可以看到，全模式和搜索引擎模式，jieba 会把全部可能组成的词都打印出来。在一般的任务当中，我们使用默认的精确模式就行了，在模糊匹配时，则需要用到全模式或者搜索引擎模式。

6、接下来，我们试着对一篇长文本作分词。导入某一段文本处理，代码如下。

```python
text = '市场有很多机遇但同时也充满杀机，野蛮生长和快速发展中如何慢慢稳住底盘，驾驭风险，保持起伏冲撞在合理的范围，特别是新兴行业，领军企业更得有胸怀和大局，需要在竞争中保持张弛有度，促成行业建立同盟和百花争艳的健康持续的多赢局面，而非最后比的是谁狠，比的是谁更有底线，劣币驱逐良币，最终谁都逃不了要还的。'

a = jieba.cut(text, cut_all=False)#精确模式

result4='|'.join(a)

print(result4)
```

运行结果为：

'市场|有|很多|机遇|但|同时|也|充满|杀机|，|野蛮|生长|和|快速|发展|中|如何|慢慢|稳住|底盘|，|驾驭|风险|，|保持|起伏|冲撞|在|合理|的|范围|，|特别|是|新兴|行业|，|领军|企业|更得|有|胸怀|和|大局|，|需要|在|竞争|中|保持|张弛|有度|，|促成|行业|建立|同盟|和|百花争艳|的|健康|持续|的|多|赢|局面|，|而|非|最后|比|的|是|谁|狠|，|比|的|是|谁|更|有|底线|，|劣币|驱逐|良币|，|最终|谁|都|逃不了|要|还|的|。'

扩展自定义词

方式一：加载

*   开发者可以指定自己自定义的词典，以便包含 jieba 词库里没有的词。虽然 jieba 有新词识别能力，但是自行添加新词可以保证更高的正确率
*   用法： jieba.load\_userdict(file\_name) # file\_name 为文件类对象或自定义词典的路径
*   词典格式和 dict.txt 一样，一个词占一行；每一行分三部分：词语、词频（可省略）、词性（可省略），用空格隔开，顺序不可颠倒。file\_name 若为路径或二进制方式打开的文件，则文件必须为 UTF-8 编码。

方式二：调整

*   使用 add\_word(word, freq=None, tag=None) 和 del\_word(word) 可在程序中动态修改词典。
*   使用 suggest\_freq(segment, tune=True) 可调节单个词语的词频，使其能（或不能）被分出来。
*   注意：自动计算的词频在使用 HMM 新词发现功能时可能无效。

7、jieba 在某些特定的情况下分词，可能表现不是很好。比如一篇非常专业的医学论文，含有一些特定领域的专有名词。不过，为了解决此类问题， jieba 允许用户自己添加该领域的自定义词典，我们可以提前把这些词加进自定义词典当中，来增加分词的效果。调用的方法是：jieba.load\_userdic()。

自定义词典的格式要求每一行一个词，有三个部分，词语，词频（词语出现的频率），词性（名词，动词……）。其中，词频和词性可省略。用户自定义词典可以直接用记事本创立即可，但是需要以 utf-8 编码模式保存。 格式像下面这样：

凶许  1  a

脑斧  2  b

福蝶  c

小局  4

海疼

使用 add\_word(word, freq=None, tag=None) 和 del\_word(word) 可在程序中动态修改词典。

使用 suggest\_freq(segment, tune=True) 可调节单个词语的词频，使其能（或不能）被分出来。

使用自定义词典，有时候可以取得更好的效果，例如「今天天气不错」这句话，本应该分出「今天」、「天气」、「不错」三个词，而来看一下直接使用结巴分词的结果：

```python
string = '今天天气不错'

seg_list = jieba.cut(string, cut_all=False)

result5='|'.join(seg_list)

print(result5)
```

运行结果为：

'今天天气|不错'

8、可以看到第7步的结果并没有被完整分割，这时候就可以加载自定义的词典了，将「今天」和「天气」两个词语添加到词典中，并重新分词:

```python
jieba.suggest_freq(('今天', '天气'), True)

seg_list = jieba.cut(string, cut_all=False)

result6='|'.join(seg_list)

print(result6)
```

运行结果为：

'今天|天气|不错'

9、也可以从词典直接删除该词语:

```python
jieba.del_word('今天天气')

seg_list = jieba.cut(string, cut_all=False)

result7='|'.join(seg_list)

print(result7)
```

运行结果为：

'今天|天气|不错'

10、还有一种情况是「台中」总是被切成「台」和「中」，因为 P(台中) ＜ P(台)×P(中)，“台中”词频不够导致其成词概率较低，这时候可以添加词典，强制调高词频。

```python
string = '台中'

seg_list = jieba.cut(string, cut_all=False)

result8='|'.join(seg_list)

print(result8)
```

运行结果为：

'台|中'

11、强制调高「台中」的词频，使它被分为一个词:

```python
jieba.add_word('台中')

seg_list = jieba.cut(string, cut_all=False)

result9='|'.join(seg_list)

print(result9)
```

运行结果为：

'台中'

12、接下来，我们利用 jieba 来做一个简单过滤器，这个在实际的应用中十分常用。比如有的词【的】，【地】，【得】，对数据分析没有什么实际作用，但是文章中大量的这类词又会占据大量的存储资源，因此我们想要过滤掉这类词。

首先建立停用词表，为了便于理解，我们直接建立一个小型的停用词表。实际中常常需要一个由大量的停用词组成的词表。

```python
stopwords = ('的', '地', '得')
string = '我喜欢的和你讨厌地以及最不想要得'#为自定义待过滤的文本：


#对 string 进行分词操作，看看没过滤之前的分词结果；并将结果存放在一个 seg_list 中:

seg_list = jieba.cut(string, cut_all=False)

result10='|'.join(seg_list)

print(result10)#打印过滤之前的分词结果



#接下来，查看过滤后结果。首先创建一个空数组来存放过滤后的词语，

# 然后通过循环迭代的方法，将过滤后的词语依次添加到刚刚建立的空数组当中。

a = []

seg_list = jieba.cut(string, cut_all=False)

for word in seg_list:

    if word not in stopwords:

        a.append(word)

print(a)#打印过滤后的词语
```

运行结果为：

我|喜欢|的|和|你|讨厌|地|以及|最|不|想要|得

\['我', '喜欢', '和', '你', '讨厌', '以及', '最', '不', '想要'\]

13、创建自定义词典：

![x-dict.png](./pic/x-dict.png)

修改默认文件名userdict.txt

![x-dict-1.png](./pic/x-dict-1.png)

在userdict.txt文件中写入以下内容：

```markup
云计算 5
李小福 2 nr
创新办 3 i
easy_install 3 eng
好用 300
韩玉赏鉴 3 nz
八一双鹿 3 nz
台中
凱特琳 nz
Edu Trust认证 2000
 
```

回到之前的代码编辑页面，先基于原始词库分词：

```python
test_sent = (
"李小福是创新办主任也是云计算方面的专家; 什么是八一双鹿\n"
"例如我输入一个带“韩玉赏鉴”的标题，在自定义词库中也增加了此词为N类\n"
"「台中」正確應該不會被切開。mac上可分出「石墨烯」；此時又可以分出來凱特琳了。"
)
words = jieba.cut(test_sent)
print('/'.join(words))
 
```

分词结果中有明显错误：

![x-dict-2.png](./pic/x-dict-2.png)

扩展自定义词并重新分词：

```python
# 加载
jieba.load_userdict("userdict.txt")
# 调整
jieba.add_word('石墨烯')
jieba.add_word('凱特琳')
jieba.del_word('自定义词')
# 重新分词
words = jieba.cut(test_sent)
print('/'.join(words))
 
```

![x-dict-3.png](./pic/x-dict-3.png)

#### 关键词抽取

（1）基于TF/IDF抽取

*   jieba.analyse.extract\_tags(sentence, topK=20, withWeight=False, allowPOS=())
    *   sentence 为待提取的文本
    *   topK 为返回几个 TF/IDF 权重最大的关键词，默认值为 20
    *   withWeight 为是否一并返回关键词权重值，默认值为 False
    *   allowPOS 仅包括指定词性的词，默认值为空，即不筛选

关键词提取所使用逆向文件频率（IDF）文本语料库可以切换成自定义语料库的路径

*   用法： jieba.analyse.set\_idf\_path(file\_name) # file\_name为自定义语料库的路径

关键词提取所使用停止词（Stop Words）文本语料库可以切换成自定义语料库的路径

*   用法： jieba.analyse.set\_stop\_words(file\_name) # file\_name为自定义语料库的路径

```python
import jieba.analyse
s = "此外，公司拟对全资子公司吉林欧亚置业有限公司增资4.3亿元，增资后，吉林欧亚置业注册资本由7000万元增加到5亿元。吉林欧亚置业主要经营范围为房地产开发及百货零售等业务。目前在建吉林欧亚城市商业综合体项目。2013年，实现营业收入0万元，实现净利润-139.13万元。"
for x, w in jieba.analyse.extract_tags(s, withWeight=True):
    print('%s %s' % (x, w))
 
```

![extract-1.png](./pic/extract-1.png)

（2）基于TextRank抽取

*   jieba.analyse.textrank(sentence, topK=20, withWeight=False, allowPOS=('ns', 'n', 'vn', 'v')) ，注意默认过滤词性。

```python
import jieba.analyse
s = "此外，公司拟对全资子公司吉林欧亚置业有限公司增资4.3亿元，增资后，吉林欧亚置业注册资本由7000万元增加到5亿元。吉林欧亚置业主要经营范围为房地产开发及百货零售等业务。目前在建吉林欧亚城市商业综合体项目。2013年，实现营业收入0万元，实现净利润-139.13万元。"
for x, w in jieba.analyse.textrank(s, withWeight=True):
    print('%s %s' % (x, w))
 
```

![extract-2.png](./pic/extract-2.png)

#### 词性标注

*   jieba.posseg.POSTokenizer(tokenizer=None) 新建自定义分词器，tokenizer 参数可指定内部使用的 jieba.Tokenizer 分词器。jieba.posseg.dt 为默认词性标注分词器。
*   标注句子分词后每个词的词性，采用和 ictclas 兼容的标记法。
*   除了jieba默认分词模式，提供paddle模式下的词性标注功能。paddle模式采用延迟加载方式

```python
import jieba.posseg as pseg
words = pseg.cut("我爱北京天安门") #jieba默认模式
# jieba.enable_paddle() #启动paddle模式。 0.40版之后开始支持，早期版本不支持
#words = pseg.cut("我爱北京天安门",use_paddle=True) #paddle模式
words = pseg.cut("我爱北京天安门") #paddle模式
for word, flag in words:
    print('%s %s' % (word, flag))
 
```

![posseg.png](./pic/posseg.png)

paddle模式词性标注对应表如下：

paddle模式词性和专名类别标签集合如下表，其中词性标签 24 个（小写字母），专名类别标签 4 个（大写字母）。

| 标签 | 含义 | 标签 | 含义 | 标签 | 含义 | 标签 | 含义 |
| --- | --- | --- | --- | --- | --- | --- | --- |
| n | 普通名词 | f | 方位名词 | s | 处所名词 | t | 时间 |
| nr | 人名 | ns | 地名 | nt | 机构名 | nw | 作品名 |
| nz | 其他专名 | v | 普通动词 | vd | 动副词 | vn | 名动词 |
| a | 形容词 | ad | 副形词 | an | 名形词 | d | 副词 |
| m | 数量词 | q | 量词 | r | 代词 | p | 介词 |
| c | 连词 | u | 助词 | xc | 其他虚词 | w | 标点符号 |
| PER | 人名 | LOC | 地名 | ORG | 机构名 | TIME | 时间 |

#### 文本向量化

1、词袋表征

(1)、文本的一种常用表征方法是使用词袋(BoW) 方法，即我们简单计算出每个词在我们的语料库——单个文本或文档的集合——中出现的次数，对于集合中的每个文本：

```python
import pandas as pd#导入pd数据分析包
from sklearn.feature_extraction.text import CountVectorizer#导入文本特征提取类
from IPython.display import HTML#将HTML输出嵌入至Python中

#设置语料库
corpus = ['The cat sat on the mat', 'The dog sat on the mat', 'The goat sat on the mat']

vectorizer = CountVectorizer(lowercase=True, analyzer='word', binary=False)#默认设置字体为小写，分析目标是word文稿，二进制计数
representation = vectorizer.fit_transform(corpus)#拟合标准化语料库数据
representation_df = pd.DataFrame(data = representation.toarray(), columns=sorted(vectorizer.vocabulary_.keys()))#存入二进制数据
representation_df
 
```

运行效果如下：

![blob-2.png](./pic/blob-2.png)

在此表征中，我们计算一个词在给定输入中出现的频率。这个计数通常被称为术语频率。语料库中所有不相同的词的集合被称为语料库的词汇表。在词袋表征中，词汇表的大小主要决定文本表征的大小。

类似表征针对相应词语使用二进制值，而不是离散计数。这通常被称为独热编码。它的优点是相对紧凑，因为词汇表中的每个词都用一个位表征。这个表征常用于术语频率与当前应用无关的情况下。

我们使用 CountVectorizer 对象，其包含在 Python 的 Scikit-Learn 机器学习工具和算法包中。查看支持 CountVectorizer 的 API。

使用 CountVectorizer 对象为每个词创建二进制值。

```python
#使用 CountVectorizer 对象为每个词创建二进制值
vectorizer =CountVectorizer(lowercase=True, analyzer='word', binary=True)
representation = vectorizer.fit_transform(corpus)#拟合标准化语料库数据
representation_df = pd.DataFrame(data = representation.toarray(), columns=sorted(vectorizer.vocabulary_.keys()))#存入二进制数据
representation_df
 
```

运行效果如下：

![blob-3.png](./pic/blob-3.png)

在许多情况下，建议去掉“the”、“on”、“in” 等“停用词”，因为这类词频繁出现，却不为文本添加意义，还需要资源来表征。不同语言的停止词不同。去掉停止词可缩减词汇表大小，从而缩减表征的总体大小。

使用 CountVectorizer 对象去掉英文停止词。

```python
#使用 CountVectorizer 对象去掉英文停止词
vectorizer = CountVectorizer(lowercase=True, analyzer='word', binary=True,stop_words=['the','on','in'])
representation = vectorizer.fit_transform(corpus)#拟合标准化语料库数据
representation_df = pd.DataFrame(data = representation.toarray(), columns=sorted(vectorizer.vocabulary_.keys()))#存入二进制数据
representation_df
 
```

运行效果如下：

![blob-4.png](./pic/blob-4.png)

还有其他的词计数表征方法，例如 TF-IDF结合一个词在给定语料库中出现的频率，考量其在文档中出现的频率。这增加了出现频率较低的词的权重，弱化了常见的、出现频率较高的词。

(2)、与词袋表征相关的问题，BoW 是表征结构数据的一种好方法，常规用于各种 NLP 任务，可快速、高效地实现 70-80% 的准确率。然而，它有三个主要缺点：词序不变性，缺乏语义泛化，表征虽大，但填充稀疏。我们将依次分析。

词序不变性，在上面的例子中，请注意，BoW 表征无法捕捉到语料库中出现的词的原始顺序。为了深入了解这个概念，考虑使用相同词，但只有顺序不同的句子的表征：

```python
ordering_corpus = ['The cat sat on the mat', 'the mat sat on the cat', 'Mat the cat the sat']#导入
ordering_vectorizer = CountVectorizer(lowercase=True, analyzer='word', binary=True, stop_words='english')#默认设置字体为小写，分析目标是word文稿，二进制计数，使用内置英文停止词
representation = ordering_vectorizer.fit_transform(ordering_corpus)
representation_df = pd.DataFrame(data = representation.toarray(), columns=sorted(ordering_vectorizer.vocabulary_.keys()))#存入二进制数据
representation_df
 
```

运行效果如下：

![blob-5.png](./pic/blob-5.png)

请注意，这些表征完全相同。特别要注意第二个句子，除非在滑稽或讽刺的语境中使用，否则没有任何意义，第三句的英文语法都不正确。虽然词序不变的表征通常对于简单的任务来说已经足够，但在许多情况下，为了获得更高的准确性，词序需包含在内。

注意：运行下面的单元后，请确保未更改矢量变量的内容，缺乏语义泛化，查看上面的句子的原始语料库，显然我们可以使用以下方式对其进行表征：

“The X sat on the mat”其中“X”是一种动物：cat（猫）、dog（狗）或 goat（山羊）。它们在 BoW 中如何表征？

```python
vectorizer.vocabulary_
 
```

运行结果：{'cat': 0, 'sat': 4, 'mat': 3, 'dog': 1, 'goat': 2}

“cat”是第一个特征（出现在独热编码向量的位置 0），“dog”是第二个特征（出现在独热编码向量的位置 1），以此类推。在这种情况下，特征似乎按字母顺序排序。我们可以通过添加字母排序在“cat”之前的另一种动物来验证：

```python
#导入特征语义库
feature_corpus = ['The cat sat on the mat', 'The dog sat on the mat', 'The bird sat on the mat']
feature_vectorizer = CountVectorizer(lowercase=True, analyzer='word', binary=True, stop_words='english')
representation = feature_vectorizer.fit_transform(feature_corpus)#拟合标准化语料库数据
representation_df = pd.DataFrame(data = representation.toarray(),columns=sorted(feature_vectorizer.vocabulary_.keys())) #存入二进制数据
representation_df
 
```

运行效果如下：

![blob-6.png](./pic/blob-6.png)

现在 bird（鸟）是第一个特征，cat（猫）是第二特征，dog（狗）是第三个特征。

在书中，有许多动物坐在垫子上，cat、dog、goat、elephant（大象）。这意味着只有动物能坐在垫子上，而其他对象不能。现在，让我们尝试构建一个简单的分类模型来决定“X on the mat”是否被允许，换句话说，这是一个文本分类问题。

```python
#训练的语料库
training_corpus = ['The cat sat on the mat', 'The dog sat on the mat', 'The goat sat on the mat', 'The elephant sat on the mat', 
          'The plane sat on the mat', 'The apple sat on the mat', 'The pen sat on the mat', 'The notebook sat on the mat']

allowed = [1,1,1,1,   # 被允许的对象在垫子上
           0,0,0,0]   #  不被允许的对象不在垫子上


#将词组键盘，鸟添加进其他对象中
for other_object in ['keyboard', 'bird']:
    training_corpus.append(other_object)  #向语料库中添加其他对象

#默认设置字体为小写，分析目标是word文稿，二进制计数，使用内置英文停用词
vectorizer = CountVectorizer(lowercase=True, analyzer='word', binary=True, stop_words='english')
representation = vectorizer.fit_transform(training_corpus)#拟合标准化语料库数据
representation_df = pd.DataFrame(data = representation.toarray(), columns=sorted(vectorizer.vocabulary_.keys()))#存入二进制数据
representation_df
 
```

运行效果如下：

![blob-7.png](./pic/blob-7.png)

```python
from sklearn.linear_model import LogisticRegression#导入逻辑回归函数
from sklearn.metrics import accuracy_score#导入打分函数
logistic = LogisticRegression()
y = allowed#y可以是任意值
X = representation_df[:len(y)]#x为y字符串长度大小

logistic.fit(X,y) # 仅训练前八个字段
print("Training accuracy score is:  {} %".format(accuracy_score(logistic.predict(X), y)*100.0))#显示打分结果
 
```

运行结果：Training accuracy score is: 100.0 %

我们看到，简单的逻辑回归模型就能够完美地学习我们的训练数据——允许动物在垫子上，其他对象不行。现在，让我们看看我们的模型能否“泛化”到其他动物和对象：

将测试语料库中的句子转换成 BoW 表征。

```python
#将测试语料库中的句子转换成 BoW 表征
test_corpus = ['The keyboard sat on the mat', 'The bird sat on the mat']
#生成测试语料的BoW表示形式
X_test = vectorizer.transform(test_corpus)#测试语义库
y_test = [0,1]
print("Expected Results for (keyboard, bird):  {}".format(y_test))#输出预期结果
#输出实际结果,格式化预测结果
print("Actual   Results for (keyboard, bird): {}".format(logistic.predict(X_test)))

 
```

运行结果：

Expected Results for (keyboard, bird): \[0, 1\]

Actual Results for (keyboard, bird): \[0 0\]

我们看到这个简单模型无法捕捉到垫子上允许的动物的泛化。也许一个更强大的模型能够做到这一点。然而，如有可能，理想情况下我们希望将“动物”这个概念（语义概念）直接捕获至输入表征。换句话说，我们想要一个“更明智”的表征，不管使用什么算法。

稀疏性，在 BoW 表征中，每个词是一个特征。因此，对于大型语料库，这意味着单个句子的独热编码向量可以很长。例如，一个包含 1000 个词的词汇表，每个句子由 10 个词组成，则单个输入向量将是 1000 x 10= 10000 个参数。一个大型语料库可轻松包含更多个词，一个句子可轻松由 30 或 40 个词组成。大型词汇表及其带来的计算复杂性问题有时被称为“维度的诅咒”

此外，一个句子通常只包含词汇表中所有可能词的一小部分。这意味着我们输入的绝大部分数值是 0。这就是所谓的稀疏表征，因为该表征只是稀疏地填充了数据。这将导致有大量的参数需要大量的数据进行训练，并且有过拟合的风险。我们可以只使用词汇表中出现较多的头 k 个单词（由于自然语言中单词的分布倾向于只有为数不多的单词出现很频繁），但这也只是权宜之计，并没有直接解决这个问题。

### 实验总结

通过本次实验，大家掌握了NLP中词法分析对应的实现方法，希望各位同学能在理解每一步的意义，并在实际应用中根据情况进行补充。